// MSM6295 module header

#define MAX_MSM6295b (2)

INT32 MSM6295bInit(INT32 nChip, INT32 nSamplerate, bool bAddSignal);
void MSM6295bSetRoute(INT32 nChip, double nVolume, INT32 nRouteDir);
void MSM6295bReset(INT32 nChip);
void MSM6295bExit(INT32 nChip);

INT32 MSM6295bRender(INT32 nChip, INT16* pSoundBuf, INT32 nSegmenLength);
void MSM6295bCommand(INT32 nChip, UINT8 nCommand);
INT32 MSM6295bScan(INT32 nChip, INT32 nAction);

extern UINT8* MSM6295bROM;
extern UINT8* MSM6295bSampleInfo[MAX_MSM6295b][4];
extern UINT8* MSM6295bSampleData[MAX_MSM6295b][4];

inline static UINT32 MSM6295bReadStatus(const INT32 nChip)
{
	extern UINT32 nMSM6295bStatus[MAX_MSM6295b];

	return nMSM6295bStatus[nChip];
}

